# -*- coding: utf-8 -*-
from detectron2.config import CfgNode as CN


def add_restv2_config(cfg):
    # restv2 backbone
    cfg.MODEL.RESTV2 = CN()
    cfg.MODEL.RESTV2.NAME = "restv2_tiny"
    cfg.MODEL.RESTV2.OUT_FEATURES = ["stage1", "stage2", "stage3", "stage4"]
    cfg.MODEL.RESTV2.WEIGHTS = None
    cfg.MODEL.BACKBONE.FREEZE_AT = 2

    # addition
    cfg.MODEL.FPN.TOP_LEVELS = 2
    cfg.SOLVER.OPTIMIZER = "AdamW"
